#version 430 core
layout(vertices = 3) out;

layout (location = 0) in vec2 vTexCoords[];
layout (location = 1) in vec4 vPosition[];

layout (location = 0) out vec2  tessTexCoords[];
layout (location = 1) out vec4  tessPosition[];

void main(void)
{
	float tessPowerInner = 4.0;
	float tessPowerOuter = 4.0;

	tessPosition[gl_InvocationID] = vPosition[gl_InvocationID];

	gl_TessLevelInner[0] = tessPowerInner;
	gl_TessLevelInner[1] = tessPowerInner;

	gl_TessLevelOuter[0] = tessPowerOuter;
	gl_TessLevelOuter[1] = tessPowerOuter;
	gl_TessLevelOuter[2] = tessPowerOuter;
	gl_TessLevelOuter[3] = tessPowerOuter;

	tessTexCoords[gl_InvocationID] = vTexCoords[gl_InvocationID];

}